(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     37744,        879]
NotebookOptionsPosition[     37224,        861]
NotebookOutlinePosition[     37655,        878]
CellTagsIndexPosition[     37612,        875]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"MatrixQ", "[", "RBVl10", "]"}], "&&", 
      RowBox[{"MatrixQ", "[", "RBVl11", "]"}]}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{
           RowBox[{"Flatten", "[", "RBVl10", "]"}], ",", "Null"}], "]"}], 
         "\[Equal]", "False"}], "&&", 
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{
           RowBox[{"Flatten", "[", "RBVl11", "]"}], ",", "Null"}], "]"}], 
         "\[Equal]", "False"}]}], ",", 
       RowBox[{"Column", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<A=\>\"", ",", 
             RowBox[{"MatrixForm", "[", "RBVl10", "]"}], ",", "\"\<, B=\>\"", 
             ",", " ", 
             RowBox[{"MatrixForm", "[", "RBVl11", "]"}], ",", "\"\<:\>\""}], 
            "}"}], "]"}], ",", 
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<A\[Or]B = \>\"", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"MemberQ", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"UnionBooleana", "[", 
                   RowBox[{"RBVl10", ",", "RBVl11"}], "]"}], "}"}], ",", 
                 "Null"}], "]"}], ",", "\"\<No existe\>\"", ",", 
               RowBox[{"UnionBooleana", "[", 
                RowBox[{"RBVl10", ",", "RBVl11"}], "]"}]}], "]"}]}], "}"}], 
           "]"}], ",", 
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<A\[And]B = \>\"", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"MemberQ", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"InterseccionBooleana", "[", 
                   RowBox[{"RBVl10", ",", "RBVl11"}], "]"}], "}"}], ",", 
                 "Null"}], "]"}], ",", "\"\<No existe\>\"", ",", 
               RowBox[{"InterseccionBooleana", "[", 
                RowBox[{"RBVl10", ",", "RBVl11"}], "]"}]}], "]"}]}], "}"}], 
           "]"}], ",", 
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<\[Not]A = \>\"", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"MemberQ", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"ComplementoBooleano", "[", "RBVl10", "]"}], "}"}], 
                 ",", "Null"}], "]"}], ",", "\"\<No existe\>\"", ",", 
               RowBox[{"ComplementoBooleano", "[", "RBVl10", "]"}]}], "]"}]}],
             "}"}], "]"}], ",", 
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<\[Not]B = \>\"", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"MemberQ", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"ComplementoBooleano", "[", "RBVl11", "]"}], "}"}], 
                 ",", "Null"}], "]"}], ",", "\"\<No existe\>\"", ",", 
               RowBox[{"ComplementoBooleano", "[", "RBVl11", "]"}]}], "]"}]}],
             "}"}], "]"}], ",", 
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<A\[CircleDot]B = \>\"", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"MemberQ", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"ProductoBooleano", "[", 
                   RowBox[{"RBVl10", ",", "RBVl11"}], "]"}], "}"}], ",", 
                 "Null"}], "]"}], ",", "\"\<No existe\>\"", ",", 
               RowBox[{"ProductoBooleano", "[", 
                RowBox[{"RBVl10", ",", "RBVl11"}], "]"}]}], "]"}]}], "}"}], 
           "]"}], ",", 
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<B\[CircleDot]A = \>\"", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"MemberQ", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"ProductoBooleano", "[", 
                   RowBox[{"RBVl11", ",", "RBVl10"}], "]"}], "}"}], ",", 
                 "Null"}], "]"}], ",", "\"\<No existe\>\"", ",", 
               RowBox[{"ProductoBooleano", "[", 
                RowBox[{"RBVl11", ",", "RBVl10"}], "]"}]}], "]"}]}], "}"}], 
           "]"}]}], "}"}], "]"}], ",", 
       RowBox[{
        RowBox[{"RBVl10", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";", 
        RowBox[{"RBVl11", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}]}]}]}],
       "]"}], ",", 
     RowBox[{
      RowBox[{"RBVl10", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";", 
      RowBox[{"RBVl11", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}]}]}]}], 
    "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Matrices booleanas\>\"", ",", "Bold", ",", "Medium"}], "]"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"RBVl10", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", 
      "\"\<A =\>\""}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"RBVl11", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", 
      "\"\<B =\>\""}], "}"}], "}"}], ",", "Delimiter", ",", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<Operaciones con las matrices booleanas: \>\"", ",", "Bold", ",", 
     "Medium"}], "]"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Center"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"UnionBooleana", "[", 
        RowBox[{"MatrizBooleanaA_List", ",", " ", "MatrizBooleanaB_List"}], 
        "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"MatrixQ", "[", 
           RowBox[{"MatrizBooleanaA", ",", "NumericQ"}], "]"}], "&&", 
          RowBox[{"MatrixQ", "[", 
           RowBox[{"MatrizBooleanaB", ",", "NumericQ"}], "]"}]}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"MBooleanQ", "[", "MatrizBooleanaA", "]"}], "&&", 
            RowBox[{"MBooleanQ", "[", "MatrizBooleanaB", "]"}]}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Dimensions", "[", "MatrizBooleanaA", "]"}], "\[Equal]", 
              RowBox[{"Dimensions", "[", "MatrizBooleanaB", "]"}]}], ",", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"RBList11", "=", 
                 RowBox[{"Dimensions", "[", "MatrizBooleanaA", "]"}]}], "}"}],
                ",", 
               RowBox[{
                RowBox[{"RBMatriz29", "=", 
                 RowBox[{"ConstantArray", "[", 
                  RowBox[{"0", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RBList11", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"RBList11", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
                RowBox[{"For", "[", 
                 RowBox[{
                  RowBox[{"RBi41", "=", "1"}], ",", 
                  RowBox[{"RBi41", "\[LessEqual]", 
                   RowBox[{"RBList11", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                  RowBox[{
                   RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"RBi42", "=", "1"}], ",", 
                    RowBox[{"RBi42", "\[LessEqual]", 
                    RowBox[{"RBList11", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Or", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MatrizBooleanaA", "[", 
                    RowBox[{"[", 
                    RowBox[{"RBi41", ",", "RBi42"}], "]"}], "]"}], "\[Equal]",
                     "1"}], ",", 
                    RowBox[{
                    RowBox[{"MatrizBooleanaB", "[", 
                    RowBox[{"[", 
                    RowBox[{"RBi41", ",", "RBi42"}], "]"}], "]"}], "\[Equal]",
                     "1"}]}], "]"}], ",", 
                    RowBox[{"RBMatriz29", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"RBMatriz29", ",", "1", ",", 
                    RowBox[{"{", 
                    RowBox[{"RBi41", ",", "RBi42"}], "}"}]}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"RBi42", "++"}]}]}], "]"}], ";", 
                   RowBox[{"RBi41", "++"}]}]}], "]"}], ";", 
                RowBox[{"MatrixForm", "[", "RBMatriz29", "]"}]}]}], "]"}]}], 
            "]"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"InterseccionBooleana", "[", 
        RowBox[{"MatrizBooleanaA_List", ",", " ", "MatrizBooleanaB_List"}], 
        "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"MatrixQ", "[", 
           RowBox[{"MatrizBooleanaA", ",", "NumericQ"}], "]"}], "&&", 
          RowBox[{"MatrixQ", "[", 
           RowBox[{"MatrizBooleanaB", ",", "NumericQ"}], "]"}]}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"MBooleanQ", "[", "MatrizBooleanaA", "]"}], "&&", 
            RowBox[{"MBooleanQ", "[", "MatrizBooleanaB", "]"}]}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Dimensions", "[", "MatrizBooleanaA", "]"}], "\[Equal]", 
              RowBox[{"Dimensions", "[", "MatrizBooleanaB", "]"}]}], ",", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"RBList12", "=", 
                 RowBox[{"Dimensions", "[", "MatrizBooleanaA", "]"}]}], "}"}],
                ",", 
               RowBox[{
                RowBox[{"RBMatriz30", "=", 
                 RowBox[{"ConstantArray", "[", 
                  RowBox[{"0", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RBList12", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"RBList12", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
                RowBox[{"For", "[", 
                 RowBox[{
                  RowBox[{"RBi43", "=", "1"}], ",", 
                  RowBox[{"RBi43", "\[LessEqual]", 
                   RowBox[{"RBList12", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                  RowBox[{
                   RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"RBi44", "=", "1"}], ",", 
                    RowBox[{"RBi44", "\[LessEqual]", 
                    RowBox[{"RBList12", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"And", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MatrizBooleanaA", "[", 
                    RowBox[{"[", 
                    RowBox[{"RBi43", ",", "RBi44"}], "]"}], "]"}], "\[Equal]",
                     "1"}], ",", 
                    RowBox[{
                    RowBox[{"MatrizBooleanaB", "[", 
                    RowBox[{"[", 
                    RowBox[{"RBi43", ",", "RBi44"}], "]"}], "]"}], "==", 
                    "1"}]}], "]"}], ",", 
                    RowBox[{"RBMatriz30", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"RBMatriz30", ",", "1", ",", 
                    RowBox[{"{", 
                    RowBox[{"RBi43", ",", "RBi44"}], "}"}]}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"RBi44", "++"}]}]}], "]"}], ";", 
                   RowBox[{"RBi43", "++"}]}]}], "]"}], ";", 
                RowBox[{"MatrixForm", "[", "RBMatriz30", "]"}]}]}], "]"}]}], 
            "]"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"ComplementoBooleano", "[", "MatrizBooleanaA_List", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MatrixQ", "[", 
          RowBox[{"MatrizBooleanaA", ",", "NumericQ"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MBooleanQ", "[", "MatrizBooleanaA", "]"}], ",", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"RBList13", "=", 
               RowBox[{"Dimensions", "[", "MatrizBooleanaA", "]"}]}], "}"}], 
             ",", 
             RowBox[{
              RowBox[{"RBMatriz31", "=", 
               RowBox[{"ConstantArray", "[", 
                RowBox[{"0", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"RBList13", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{"RBList13", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"RBi45", "=", "1"}], ",", 
                RowBox[{"RBi45", "\[LessEqual]", 
                 RowBox[{"RBList13", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"For", "[", 
                  RowBox[{
                   RowBox[{"RBi46", "=", "1"}], ",", 
                   RowBox[{"RBi46", "\[LessEqual]", 
                    RowBox[{"RBList13", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                   RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MatrizBooleanaA", "[", 
                    RowBox[{"[", 
                    RowBox[{"RBi45", ",", "RBi46"}], "]"}], "]"}], "\[Equal]",
                     "1"}], ",", 
                    RowBox[{"RBMatriz31", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"RBMatriz31", ",", "0", ",", 
                    RowBox[{"{", 
                    RowBox[{"RBi45", ",", "RBi46"}], "}"}]}], "]"}]}], ",", 
                    RowBox[{"RBMatriz31", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"RBMatriz31", ",", "1", ",", 
                    RowBox[{"{", 
                    RowBox[{"RBi45", ",", "RBi46"}], "}"}]}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"RBi46", "++"}]}]}], "]"}], ";", 
                 RowBox[{"RBi45", "++"}]}]}], "]"}], ";", 
              RowBox[{"MatrixForm", "[", "RBMatriz31", "]"}]}]}], "]"}]}], 
          "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"ProductoBooleano", "[", 
        RowBox[{"MatrizBooleanaA_List", ",", " ", "MatrizBooleanaB_List"}], 
        "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"MatrixQ", "[", 
           RowBox[{"MatrizBooleanaA", ",", "NumericQ"}], "]"}], "&&", 
          RowBox[{"MatrixQ", "[", 
           RowBox[{"MatrizBooleanaB", ",", "NumericQ"}], "]"}]}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"MBooleanQ", "[", "MatrizBooleanaA", "]"}], "&&", 
            RowBox[{"MBooleanQ", "[", "MatrizBooleanaB", "]"}]}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"Dimensions", "[", "MatrizBooleanaA", "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"Dimensions", "[", "MatrizBooleanaB", "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ",", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"RBList14", "=", 
                  RowBox[{"Dimensions", "[", "MatrizBooleanaA", "]"}]}], ",", 
                 RowBox[{"RBList15", "=", 
                  RowBox[{"Dimensions", "[", "MatrizBooleanaB", "]"}]}]}], 
                "}"}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"RBMatriz32", "=", 
                 RowBox[{"ConstantArray", "[", 
                  RowBox[{"0", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RBList14", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"RBList15", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"For", "[", 
                 RowBox[{
                  RowBox[{"RBi47", "=", "1"}], ",", 
                  RowBox[{"RBi47", "\[LessEqual]", 
                   RowBox[{"RBList14", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                  RowBox[{
                   RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"RBi48", "=", "1"}], ",", 
                    RowBox[{"RBi48", "\[LessEqual]", 
                    RowBox[{"RBList15", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"RBi49", "=", "1"}], ",", 
                    RowBox[{"RBi49", "\[LessEqual]", 
                    RowBox[{"RBList14", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"And", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MatrizBooleanaA", "[", 
                    RowBox[{"[", 
                    RowBox[{"RBi47", ",", "RBi49"}], "]"}], "]"}], "\[Equal]",
                     "1"}], ",", 
                    RowBox[{
                    RowBox[{"MatrizBooleanaB", "[", 
                    RowBox[{"[", 
                    RowBox[{"RBi49", ",", "RBi48"}], "]"}], "]"}], "\[Equal]",
                     "1"}]}], "]"}], ",", 
                    RowBox[{"RBMatriz32", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"RBMatriz32", ",", "1", ",", 
                    RowBox[{"{", 
                    RowBox[{"RBi47", ",", "RBi48"}], "}"}]}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"RBi49", "++"}]}]}], "]"}], ";", 
                    RowBox[{"RBi48", "++"}]}]}], "]"}], ";", 
                   RowBox[{"RBi47", "++"}]}]}], "]"}], ";", 
                RowBox[{"MatrixForm", "[", "RBMatriz32", "]"}]}]}], "]"}]}], 
            "]"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"MBooleanQ", "[", "MatrizSBooleana_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MatrixQ", "[", 
          RowBox[{"MatrizSBooleana", ",", "NumericQ"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"MemberQ", "[", 
              RowBox[{
               RowBox[{"MatrizSBooleana", "[", 
                RowBox[{"[", 
                 RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", "Null"}], 
              "]"}], "\[Equal]", "False"}], "&&", 
            RowBox[{
             RowBox[{"MemberQ", "[", 
              RowBox[{
               RowBox[{"MatrizSBooleana", "[", 
                RowBox[{"[", 
                 RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "Null"}], 
              "]"}], "\[Equal]", "False"}]}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MatrizSBooleana", "^", "2"}], "==", 
              "MatrizSBooleana"}], ",", "True", ",", "False"}], "]"}]}], 
          "]"}], ",", "False"}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Column", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Spacer", "[", 
             RowBox[{"{", 
              RowBox[{"400", ",", "2"}], "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Autor: Enrique V\[IAcute]lchez Quesada\>\"", ",", "Bold", 
                ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}], 
              "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica\>\"", ",", "Bold", ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.12", ",", "0", ",", "0.5"}], "]"}]}], "]"}], 
              "}"}], "]"}]}], "}"}], ",", "Center"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<Operaciones con matrices booleanas\>\"", ",", " ", "Bold", ",", 
          " ", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}]}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6681006287867455`*^9, 3.6681006928551044`*^9}, {
  3.6681007748920746`*^9, 3.668100806037994*^9}, {3.668100840076138*^9, 
  3.668100892975784*^9}, {3.6681009545260353`*^9, 3.6681009579271374`*^9}, {
  3.6681009883289933`*^9, 3.6681010167713013`*^9}, {3.6681010733781433`*^9, 
  3.668101074220049*^9}, {3.6681012013389635`*^9, 3.668101254942732*^9}, {
  3.668101507127869*^9, 3.6681015287395554`*^9}, {3.6681038076157255`*^9, 
  3.668103849500146*^9}, {3.801155730220555*^9, 3.8011557432466087`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"c1fece51-6022-4a02-9cd0-56651d3cae70"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`RBVl10$$ = {{1, 0, 1}, {1, 0, 0}, {1, 0, 
    1}, {0, 1, 0}}, $CellContext`RBVl11$$ = {{0, 0, 0, 0}, {1, 1, 1, 0}, {1, 
    1, 1, 1}}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[
       Style["Matrices booleanas", Bold, Medium]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`RBVl10$$], {{1, 0, 1}, {1, 0, 0}, {1, 0, 1}, {0, 1, 
       0}}, "A ="}}, {{
       Hold[$CellContext`RBVl11$$], {{0, 0, 0, 0}, {1, 1, 1, 0}, {1, 1, 1, 
       1}}, "B ="}}, {
      Hold[
       Style["Operaciones con las matrices booleanas: ", Bold, Medium]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    290., {255., 264.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`RBVl10$$ = {{1, 0, 1}, {1, 0, 0}, {1, 0, 
         1}, {0, 1, 0}}, $CellContext`RBVl11$$ = {{0, 0, 0, 0}, {1, 1, 1, 
         0}, {1, 1, 1, 1}}}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> If[
        And[
         MatrixQ[$CellContext`RBVl10$$], 
         MatrixQ[$CellContext`RBVl11$$]], 
        If[
         And[MemberQ[
            Flatten[$CellContext`RBVl10$$], Null] == False, MemberQ[
            Flatten[$CellContext`RBVl11$$], Null] == False], 
         Column[{
           Row[{"A=", 
             MatrixForm[$CellContext`RBVl10$$], ", B=", 
             MatrixForm[$CellContext`RBVl11$$], ":"}], 
           Row[{"A\[Or]B = ", 
             If[
              MemberQ[{
                $CellContext`UnionBooleana[$CellContext`RBVl10$$, \
$CellContext`RBVl11$$]}, Null], "No existe", 
              $CellContext`UnionBooleana[$CellContext`RBVl10$$, \
$CellContext`RBVl11$$]]}], 
           Row[{"A\[And]B = ", 
             If[
              MemberQ[{
                $CellContext`InterseccionBooleana[$CellContext`RBVl10$$, \
$CellContext`RBVl11$$]}, Null], "No existe", 
              $CellContext`InterseccionBooleana[$CellContext`RBVl10$$, \
$CellContext`RBVl11$$]]}], 
           Row[{"\[Not]A = ", 
             If[
              MemberQ[{
                $CellContext`ComplementoBooleano[$CellContext`RBVl10$$]}, 
               Null], "No existe", 
              $CellContext`ComplementoBooleano[$CellContext`RBVl10$$]]}], 
           Row[{"\[Not]B = ", 
             If[
              MemberQ[{
                $CellContext`ComplementoBooleano[$CellContext`RBVl11$$]}, 
               Null], "No existe", 
              $CellContext`ComplementoBooleano[$CellContext`RBVl11$$]]}], 
           Row[{"A\[CircleDot]B = ", 
             If[
              MemberQ[{
                $CellContext`ProductoBooleano[$CellContext`RBVl10$$, \
$CellContext`RBVl11$$]}, Null], "No existe", 
              $CellContext`ProductoBooleano[$CellContext`RBVl10$$, \
$CellContext`RBVl11$$]]}], 
           Row[{"B\[CircleDot]A = ", 
             If[
              MemberQ[{
                $CellContext`ProductoBooleano[$CellContext`RBVl11$$, \
$CellContext`RBVl10$$]}, Null], "No existe", 
              $CellContext`ProductoBooleano[$CellContext`RBVl11$$, \
$CellContext`RBVl10$$]]}]}], $CellContext`RBVl10$$ = {{1, 0, 1}, {1, 0, 0}, {
           1, 0, 1}, {0, 1, 0}}; $CellContext`RBVl11$$ = {{0, 0, 0, 0}, {1, 1,
            1, 0}, {1, 1, 1, 1}}], $CellContext`RBVl10$$ = {{1, 0, 1}, {1, 0, 
          0}, {1, 0, 1}, {0, 1, 0}}; $CellContext`RBVl11$$ = {{0, 0, 0, 0}, {
          1, 1, 1, 0}, {1, 1, 1, 1}}], "Specifications" :> {
        Style[
        "Matrices booleanas", Bold, 
         Medium], {{$CellContext`RBVl10$$, {{1, 0, 1}, {1, 0, 0}, {1, 0, 1}, {
          0, 1, 0}}, "A ="}}, {{$CellContext`RBVl11$$, {{0, 0, 0, 0}, {1, 1, 
          1, 0}, {1, 1, 1, 1}}, "B ="}}, Delimiter, 
        Style["Operaciones con las matrices booleanas: ", Bold, Medium]}, 
      "Options" :> {Alignment -> Center, FrameLabel -> {{None, None}, {
           Column[{
             Spacer[{400, 2}], 
             Row[{
               Style["Autor: Enrique V\[IAcute]lchez Quesada", Bold, 10, 
                RGBColor[0, 0.333333, 0]]}], 
             Row[{
               Style[
               "Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica", Bold, 10, 
                RGBColor[0.12, 0, 0.5]]}]}, Center], 
           Style["Operaciones con matrices booleanas", Bold, 
            RGBColor[0, 0.333333, 0]]}}}, "DefaultOptions" :> {}],
     ImageSizeCache->{624., {427., 436.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(($CellContext`UnionBooleana[
         Pattern[$CellContext`MatrizBooleanaA, 
          Blank[List]], 
         Pattern[$CellContext`MatrizBooleanaB, 
          Blank[List]]] := If[
         And[
          MatrixQ[$CellContext`MatrizBooleanaA, NumericQ], 
          MatrixQ[$CellContext`MatrizBooleanaB, NumericQ]], 
         If[
          And[
           $CellContext`MBooleanQ[$CellContext`MatrizBooleanaA], 
           $CellContext`MBooleanQ[$CellContext`MatrizBooleanaB]], 
          If[
          Dimensions[$CellContext`MatrizBooleanaA] == 
           Dimensions[$CellContext`MatrizBooleanaB], 
           
           Module[{$CellContext`RBList11 = 
             Dimensions[$CellContext`MatrizBooleanaA]}, \
$CellContext`RBMatriz29 = ConstantArray[0, {
                Part[$CellContext`RBList11, 1], 
                Part[$CellContext`RBList11, 2]}]; 
            For[$CellContext`RBi41 = 1, $CellContext`RBi41 <= 
              Part[$CellContext`RBList11, 1], 
              For[$CellContext`RBi42 = 1, $CellContext`RBi42 <= 
                Part[$CellContext`RBList11, 2], If[
                  Or[
                  Part[$CellContext`MatrizBooleanaA, $CellContext`RBi41, \
$CellContext`RBi42] == 1, 
                   Part[$CellContext`MatrizBooleanaB, $CellContext`RBi41, \
$CellContext`RBi42] == 1], $CellContext`RBMatriz29 = 
                  ReplacePart[$CellContext`RBMatriz29, 
                    1, {$CellContext`RBi41, $CellContext`RBi42}]]; 
                Increment[$CellContext`RBi42]]; 
              Increment[$CellContext`RBi41]]; 
            MatrixForm[$CellContext`RBMatriz29]]]]]; \
$CellContext`InterseccionBooleana[
         Pattern[$CellContext`MatrizBooleanaA, 
          Blank[List]], 
         Pattern[$CellContext`MatrizBooleanaB, 
          Blank[List]]] := If[
         And[
          MatrixQ[$CellContext`MatrizBooleanaA, NumericQ], 
          MatrixQ[$CellContext`MatrizBooleanaB, NumericQ]], 
         If[
          And[
           $CellContext`MBooleanQ[$CellContext`MatrizBooleanaA], 
           $CellContext`MBooleanQ[$CellContext`MatrizBooleanaB]], 
          If[
          Dimensions[$CellContext`MatrizBooleanaA] == 
           Dimensions[$CellContext`MatrizBooleanaB], 
           
           Module[{$CellContext`RBList12 = 
             Dimensions[$CellContext`MatrizBooleanaA]}, \
$CellContext`RBMatriz30 = ConstantArray[0, {
                Part[$CellContext`RBList12, 1], 
                Part[$CellContext`RBList12, 2]}]; 
            For[$CellContext`RBi43 = 1, $CellContext`RBi43 <= 
              Part[$CellContext`RBList12, 1], 
              For[$CellContext`RBi44 = 1, $CellContext`RBi44 <= 
                Part[$CellContext`RBList12, 2], If[
                  And[
                  Part[$CellContext`MatrizBooleanaA, $CellContext`RBi43, \
$CellContext`RBi44] == 1, 
                   Part[$CellContext`MatrizBooleanaB, $CellContext`RBi43, \
$CellContext`RBi44] == 1], $CellContext`RBMatriz30 = 
                  ReplacePart[$CellContext`RBMatriz30, 
                    1, {$CellContext`RBi43, $CellContext`RBi44}]]; 
                Increment[$CellContext`RBi44]]; 
              Increment[$CellContext`RBi43]]; 
            MatrixForm[$CellContext`RBMatriz30]]]]]; \
$CellContext`ComplementoBooleano[
         Pattern[$CellContext`MatrizBooleanaA, 
          Blank[List]]] := If[
         MatrixQ[$CellContext`MatrizBooleanaA, NumericQ], 
         If[
          $CellContext`MBooleanQ[$CellContext`MatrizBooleanaA], 
          
          Module[{$CellContext`RBList13 = 
            Dimensions[$CellContext`MatrizBooleanaA]}, \
$CellContext`RBMatriz31 = ConstantArray[0, {
               Part[$CellContext`RBList13, 1], 
               Part[$CellContext`RBList13, 2]}]; 
           For[$CellContext`RBi45 = 1, $CellContext`RBi45 <= 
             Part[$CellContext`RBList13, 1], 
             For[$CellContext`RBi46 = 1, $CellContext`RBi46 <= 
               Part[$CellContext`RBList13, 2], 
               If[Part[$CellContext`MatrizBooleanaA, $CellContext`RBi45, \
$CellContext`RBi46] == 1, $CellContext`RBMatriz31 = 
                 ReplacePart[$CellContext`RBMatriz31, 
                   0, {$CellContext`RBi45, $CellContext`RBi46}], \
$CellContext`RBMatriz31 = 
                 ReplacePart[$CellContext`RBMatriz31, 
                   1, {$CellContext`RBi45, $CellContext`RBi46}]]; 
               Increment[$CellContext`RBi46]]; Increment[$CellContext`RBi45]]; 
           MatrixForm[$CellContext`RBMatriz31]]]]; \
$CellContext`ProductoBooleano[
         Pattern[$CellContext`MatrizBooleanaA, 
          Blank[List]], 
         Pattern[$CellContext`MatrizBooleanaB, 
          Blank[List]]] := If[
         And[
          MatrixQ[$CellContext`MatrizBooleanaA, NumericQ], 
          MatrixQ[$CellContext`MatrizBooleanaB, NumericQ]], 
         If[
          And[
           $CellContext`MBooleanQ[$CellContext`MatrizBooleanaA], 
           $CellContext`MBooleanQ[$CellContext`MatrizBooleanaB]], 
          If[Part[
             Dimensions[$CellContext`MatrizBooleanaA], 2] == Part[
             Dimensions[$CellContext`MatrizBooleanaB], 1], 
           
           Module[{$CellContext`RBList14 = 
             Dimensions[$CellContext`MatrizBooleanaA], $CellContext`RBList15 = D\
imensions[$CellContext`MatrizBooleanaB]}, $CellContext`RBMatriz32 = 
             ConstantArray[0, {
                Part[$CellContext`RBList14, 1], 
                Part[$CellContext`RBList15, 2]}]; 
            For[$CellContext`RBi47 = 1, $CellContext`RBi47 <= 
              Part[$CellContext`RBList14, 1], 
              For[$CellContext`RBi48 = 1, $CellContext`RBi48 <= 
                Part[$CellContext`RBList15, 2], 
                For[$CellContext`RBi49 = 1, $CellContext`RBi49 <= 
                  Part[$CellContext`RBList14, 2], If[
                    And[
                    Part[$CellContext`MatrizBooleanaA, $CellContext`RBi47, \
$CellContext`RBi49] == 1, 
                    Part[$CellContext`MatrizBooleanaB, $CellContext`RBi49, \
$CellContext`RBi48] == 1], $CellContext`RBMatriz32 = 
                    ReplacePart[$CellContext`RBMatriz32, 
                    1, {$CellContext`RBi47, $CellContext`RBi48}]]; 
                  Increment[$CellContext`RBi49]]; 
                Increment[$CellContext`RBi48]]; 
              Increment[$CellContext`RBi47]]; 
            MatrixForm[$CellContext`RBMatriz32]]]]]; $CellContext`MBooleanQ[
         Pattern[$CellContext`MatrizSBooleana, 
          Blank[]]] := If[
         MatrixQ[$CellContext`MatrizSBooleana, NumericQ], 
         If[
          And[MemberQ[
             Part[$CellContext`MatrizSBooleana, All, 1], Null] == False, 
           MemberQ[
             Part[$CellContext`MatrizSBooleana, All, 2], Null] == False], 
          
          If[$CellContext`MatrizSBooleana^2 == $CellContext`MatrizSBooleana, 
           True, False]], False]); Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.6681009588005033`*^9, 3.668101017590008*^9, 3.668101076710868*^9, 
   3.668101150664013*^9, 3.6681012143463144`*^9, 3.66810127636304*^9, 
   3.6681015352423253`*^9, {3.6681020436086025`*^9, 3.6681020731729436`*^9}, {
   3.6681038568889065`*^9, 3.6681038719187126`*^9}, 3.80115648648755*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"4a2864b0-5eff-4111-83b4-cde87f015ea7"]
}, Open  ]]
},
WindowSize->{1366, 685},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5c45c40f-1ea6-44ac-9f20-80165d1564c7"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 23978, 569, 3753, "Input",ExpressionUUID->"c1fece51-6022-4a02-9cd0-56651d3cae70"],
Cell[24561, 593, 12647, 265, 932, "Output",ExpressionUUID->"4a2864b0-5eff-4111-83b4-cde87f015ea7"]
}, Open  ]]
}
]
*)

